//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Distribution of inheritances and gifts by age band.
// Objective: 	Calculate the proportion of respondents within each five year
//				age band who report receiving an inheritance or parental gift
//				each year.
//
// Created: 	04/06/2021
// Modified: 	15/11/2021
//==============================================================================

*************************************
*** Loading and cleaning the data ***
*************************************

clear	// clearing the dataset

cd "XXXX"	// set the content directory here

use HILDA_restricted_combined_rescaled	// importing the unconfidentialised HILDA data for waves 1-19 that includes the new weights for residents of non-private dwellings

xtset xwaveid wave	// declaring the dataset to be a panel

merge m:1 year using CPI_FY_2018.dta	// merging financial-year CPI data to allow the gift values to be converted to constant 2018 dollars

********************
*** Inheritances ***
********************

drop if hgint == 0	// dropping non-responding persons

tab oifinh							// tabulating the inheritance variable
replace oifinh = 0 if oifinh < 0	// replacing negative values as zero

tab oifinha							// tabulating the inheritance value variable
replace oifinha = 0 if oifinha < 0	// replacing negative values as zero

keep year hgage hgsex oifinh oifinha cpi benchmarked_new_hhwtrp xwaveid	// keeping the key variables

keep if oifinh == 1	// keeping only those who received an inheritance

replace oifinha = oifinha * (100/cpi)	// converting the inheritances to constant 2018 dollars

replace oifinha = . if oifinha == 0	// replacing inheritances of zero value as missing

egen age_band = cut(hgage), at(0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100)	// generating five year age bands

gen wt_inheritance = oifinha * benchmarked_new_hhwtrp	// weighting the inheritance variable by the new, benchmarked, enumerated-person weights

by age_band, sort: egen num_inheritances = sum(benchmarked_new_hhwtrp)	// calculating the total number of inheritances received by each age band
by age_band, sort: egen sum_inheritances = sum(wt_inheritance)	// calculating the total value of inheritances received by each age band

collapse num_inheritances sum_inheritances, by(age_band)	// collapsing the dataset to leave the number and total value of inheritances received by each age band

gen avg_inheritance = sum_inheritances / num_inheritances	// calculating the average inheritance received by each age band

save inheritance_distribution_by_age.dta, replace	// saving the dataset

*************************************
*** Loading and cleaning the data ***
*************************************

clear	// clearing the dataset

use HILDA_restricted_combined_rescaled	// importing the unconfidentialised HILDA data for waves 1-19 that includes the new weights for residents of non-private dwellings

xtset xwaveid wave	// declaring the dataset to be a panel

merge m:1 year using CPI_FY_2018.dta	// merging CPI data to allow the gift values to be converted to constant 2018 dollars

*************
*** Gifts ***
*************

drop if hgint == 0	// dropping non-responding persons

replace oifpnt = 0 if oifpnt < 0	// replacing negative gift receipt values as zero
replace oifpnta = 0 if oifpnta < 0	// replacing negative gift values as zero

keep year hgage hgsex xwaveid oifpnt oifpnta cpi benchmarked_new_hhwtrp	// keeping the key variables

keep if oifpnt == 1	// keeping only those who reported receiving a gift

replace oifpnta = oifpnta * (100/cpi)	// converting the gifts to constant 2018 dollars

replace oifpnta = . if oifpnta == 0	// replacing gifts of zero value as missing

egen age_band = cut(hgage), at(0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,75,80,85,90,95,100)	// generating five year age bands

gen wt_gift = oifpnta * benchmarked_new_hhwtrp	// weighting the gift variable by the new, benchmarked, enumerated-person weights

by age_band, sort: egen num_gifts = sum(benchmarked_new_hhwtrp)	// calculating the total number of gifts received by each age band
by age_band, sort: egen sum_gifts = sum(wt_gift)	// calculating the total value of gfits received by each age band

collapse num_gifts sum_gifts, by(age_band)	// collapsing the dataset to leave the number and total value of gifts received by each age band

gen avg_gift = sum_gifts / num_gifts	// calculating the average gift received by each age band

save gift_distribution_by_age.dta, replace	// saving the dataset

****************************
*** Merging the datasets ***
****************************

merge 1:1 age_band using inheritance_distribution_by_age.dta, nogen

egen total_inheritances = sum(num_inheritances)
gen share_inheritances = num_inheritances / total_inheritances
drop total_inheritances

egen total_gifts = sum(num_gifts)
gen share_gifts = num_gifts / total_gifts
drop total_gifts

save inheritance_and_gift_distribution_by_age.dta, replace	// saving the combined dataset